<?php
$script = $_SERVER['SCRIPT_NAME'] ?? '';
$baseUrl = rtrim(dirname($script), '/');
// ensure baseUrl ends at /public
if (!str_ends_with($baseUrl, '/public')) {
  // try to locate "/public" in path
  $pos = strpos($script, '/public/');
  $baseUrl = ($pos !== false) ? substr($script, 0, $pos + 7) : $baseUrl;
}
$path = basename($_SERVER['PHP_SELF']);
function nav_active(string $needle): string {
  $p = basename($_SERVER['PHP_SELF']);
  return str_contains($p, $needle) ? 'active' : '';
}
?>
<div class="sidebar card-glass">
  <div class="mb-2 text-muted small">Navigation</div>
  <nav class="nav flex-column gap-1">
    <a class="nav-link <?= $path==='index.php'?'active':'' ?>" href="<?= esc($baseUrl) ?>/index.php">Dashboard</a>

    <div class="text-muted small mt-2">Governance</div>
    <a class="nav-link <?= nav_active('school.php') ?>" href="<?= esc($baseUrl) ?>/modules/setup/school.php">School Profile</a>
    <a class="nav-link <?= nav_active('bom_members.php') ?>" href="<?= esc($baseUrl) ?>/modules/governance/bom_members.php">BOM Members</a>
    <a class="nav-link <?= nav_active('committee_meetings.php') ?>" href="<?= esc($baseUrl) ?>/modules/governance/committee_meetings.php">Committees & Meetings</a>

    <div class="text-muted small mt-2">Setup</div>
    <a class="nav-link <?= nav_active('banks.php') ?>" href="<?= esc($baseUrl) ?>/modules/setup/banks.php">Bank Accounts</a>
    <a class="nav-link <?= nav_active('cash_positions.php') ?>" href="<?= esc($baseUrl) ?>/modules/setup/cash_positions.php">Cash Positions</a>
    <a class="nav-link <?= nav_active('fiscal_years.php') ?>" href="<?= esc($baseUrl) ?>/modules/setup/fiscal_years.php">Fiscal Years</a>
    <a class="nav-link <?= nav_active('vote_items.php') ?>" href="<?= esc($baseUrl) ?>/modules/setup/vote_items.php">Vote Heads</a>

    <div class="text-muted small mt-2">Finance</div>
    <a class="nav-link <?= nav_active('receipts') ?>" href="<?= esc($baseUrl) ?>/modules/finance/receipts_list.php">Receipts</a>
    <a class="nav-link <?= nav_active('payments') ?>" href="<?= esc($baseUrl) ?>/modules/finance/payments_list.php">Payments</a>
    <a class="nav-link <?= nav_active('receivables.php') ?>" href="<?= esc($baseUrl) ?>/modules/finance/receivables.php">Receivables + Ageing</a>
    <a class="nav-link <?= nav_active('payables.php') ?>" href="<?= esc($baseUrl) ?>/modules/finance/payables.php">Payables + Ageing</a>

    <div class="text-muted small mt-2">Budget</div>
    <a class="nav-link <?= nav_active('budget_lines.php') ?>" href="<?= esc($baseUrl) ?>/modules/budget/budget_lines.php">Budget vs Actual</a>

    <div class="text-muted small mt-2">Projects & Assets</div>
    <a class="nav-link <?= nav_active('projects.php') ?>" href="<?= esc($baseUrl) ?>/modules/projects/projects.php">Projects Register</a>
    <a class="nav-link <?= nav_active('assets.php') ?>" href="<?= esc($baseUrl) ?>/modules/assets/assets.php">Fixed Assets Register</a>

    <div class="text-muted small mt-2">Reports</div>
    <a class="nav-link <?= nav_active('ipsas_pack.php') ?>" href="<?= esc($baseUrl) ?>/modules/reports/ipsas_pack.php">IPSAS Pack</a>
    <a class="nav-link <?= nav_active('annex_payables.php') ?>" href="<?= esc($baseUrl) ?>/modules/reports/annex_payables.php">Annex I: Pending Payables</a>
    <a class="nav-link <?= nav_active('annex_assets.php') ?>" href="<?= esc($baseUrl) ?>/modules/reports/annex_assets.php">Annex II: Fixed Assets</a>
    <a class="nav-link <?= nav_active('cashflow.php') ?>" href="<?= esc($baseUrl) ?>/modules/reports/cashflow.php">Cash Flow (Direct)</a>

    <div class="text-muted small mt-2">Audit</div>
    <a class="nav-link <?= nav_active('audit_logs.php') ?>" href="<?= esc($baseUrl) ?>/modules/audit/audit_logs.php">Audit Logs</a>
  </nav>
</div>
