<?php
require_once __DIR__ . '/../../app/bootstrap.php';
$u = current_user();
$flash = take_flash();
?>
<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?= esc(app_name()) ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="assets/css/theme.css" rel="stylesheet">
</head>
<body>
  <div class="container py-3">
    <div class="navbar-glass p-3 mb-3 d-flex align-items-center justify-content-between">
      <div>
        <div class="fw-bold" style="letter-spacing:-.02em; font-size:1.05rem;"><?= esc(app_name()) ?></div>
        <div class="text-muted small">Kenya Public Secondary School IPSAS Reporting MVP</div>
      </div>
      <div class="d-flex gap-2 align-items-center">
        <?php if ($u): ?>
          <span class="badge badge-soft">Tenant #<?= (int)$u['tenant_id'] ?></span>
          <span class="badge badge-soft"><?= esc($u['role']) ?></span>
          <span class="badge badge-soft"><?= esc($u['name']) ?></span>
          <a class="btn btn-sm btn-outline-light" href="logout.php">Logout</a>
        <?php else: ?>
          <a class="btn btn-sm btn-accent" href="login.php">Login</a>
        <?php endif; ?>
      </div>
    </div>

    <?php if ($flash): ?>
      <div class="alert alert-<?= esc($flash['type']) ?> card-glass border-0">
        <?= esc($flash['msg']) ?>
      </div>
    <?php endif; ?>

