<?php
require_once __DIR__ . '/../../../app/bootstrap.php';
$u = require_login(); $tid = tenant_id(); $pdo = db();
csrf_check();

$groups = ['Revenue','Tuition','Operations','Infrastructure','School Fund'];

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $group = (string)($_POST['group'] ?? 'Revenue');
  $name  = trim((string)($_POST['name'] ?? ''));
  $note_no = (string)($_POST['note_no'] ?? '');
  $stmt_line = trim((string)($_POST['stmt_line'] ?? ''));
  $pdo->prepare("INSERT INTO vote_items (tenant_id,grp,name,note_no,stmt_line) VALUES (?,?,?,?,?)")
    ->execute([$tid,$group,$name,$note_no,$stmt_line]);
  flash("Vote item added.", "success");
  header('Location: vote_items.php'); exit;
}

if (isset($_GET['seed'])) {
  // Seed a minimal IPSAS-like list quickly
  $seed = [
    // Revenue
    ['Revenue','Government grants for tuition','1','Revenue'],
    ['Revenue','Government grants for operations','2','Revenue'],
    ['Revenue','Government Grants for infrastructure','3','Revenue'],
    ['Revenue','School fund income- parents’ contributions','4','Revenue'],
    ['Revenue','Miscellaneous incomes','5','Revenue'],
    // Expenditure buckets
    ['Tuition','Textbooks','6','Expenditure: Tuition'],
    ['Tuition','Reference Materials','6','Expenditure: Tuition'],
    ['Operations','Personnel Emoluments','7','Expenditure: Operations'],
    ['Operations','Repairs And Maintenance','7','Expenditure: Operations'],
    ['Infrastructure','Construction of classrooms','8','Expenditure: Infrastructure'],
    ['School Fund','Lunch Programme','9','Expenditure: School Fund'],
  ];
  $st = $pdo->prepare("INSERT INTO vote_items (tenant_id,grp,name,note_no,stmt_line) VALUES (?,?,?,?,?)");
  foreach ($seed as $s) $st->execute([$tid,$s[0],$s[1],$s[2],$s[3]]);
  flash("Seeded a starter Vote Head list. You can edit/expand to match your school.", "success");
  header('Location: vote_items.php'); exit;
}

if (isset($_GET['del'])) {
  $id = (int)$_GET['del'];
  $pdo->prepare("DELETE FROM vote_items WHERE tenant_id=? AND id=?")->execute([$tid,$id]);
  flash("Vote item deleted.", "warning");
  header('Location: vote_items.php'); exit;
}

$st = $pdo->prepare("SELECT * FROM vote_items WHERE tenant_id=? ORDER BY grp, name");
$st->execute([$tid]);
$rows = $st->fetchAll();

include __DIR__ . '/../../partials/header.php';
?>
<div class="row g-3">
  <div class="col-lg-3"><?php include __DIR__ . '/../../partials/sidebar.php'; ?></div>
  <div class="col-lg-9">
    <div class="card-glass p-4 mb-3">
      <div class="d-flex justify-content-between align-items-start">
        <div>
          <h4 class="fw-bold mb-1">Vote Heads (Mapping)</h4>
          <div class="text-muted">These drive Budget lines, receipts/payments classification, and IPSAS notes.</div>
        </div>
        <div class="d-flex gap-2">
          <a class="btn btn-outline-light" href="?seed=1" onclick="return confirm('Seed starter vote heads?')">Seed Starter List</a>
          <span class="badge badge-soft">Setup</span>
        </div>
      </div>
      <hr class="border-0" style="height:1px;background:rgba(255,255,255,.10)">
      <form method="post" class="row g-2 align-items-end">
        <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
        <div class="col-md-2">
          <label class="form-label">Group</label>
          <select class="form-select" name="group">
            <?php foreach ($groups as $g): ?>
              <option value="<?= esc($g) ?>"><?= esc($g) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-5">
          <label class="form-label">Name</label>
          <input class="form-control" name="name" required placeholder="e.g., Reference Materials">
        </div>
        <div class="col-md-2">
          <label class="form-label">Note No.</label>
          <input class="form-control" name="note_no" placeholder="e.g., 1">
        </div>
        <div class="col-md-3">
          <label class="form-label">Statement Line (label)</label>
          <input class="form-control" name="stmt_line" placeholder="e.g., Revenue / Expenditure: Tuition">
        </div>
        <div class="col-12">
          <button class="btn btn-accent">Add Vote Item</button>
        </div>
      </form>
    </div>

    <div class="card-glass p-3">
      <div class="fw-bold mb-2">Vote Items</div>
      <div class="table-responsive">
        <table class="table table-darkish table-hover align-middle">
          <thead><tr><th>Group</th><th>Name</th><th>Note</th><th>Statement Line</th><th></th></tr></thead>
          <tbody>
            <?php foreach ($rows as $r): ?>
              <tr>
                <td><span class="badge badge-soft"><?= esc($r['grp']) ?></span></td>
                <td><?= esc($r['name']) ?></td>
                <td><?= esc($r['note_no']) ?></td>
                <td class="text-muted"><?= esc($r['stmt_line']) ?></td>
                <td class="text-end">
                  <a class="btn btn-sm btn-outline-light" href="?del=<?= (int)$r['id'] ?>" onclick="return confirm('Delete?')">Delete</a>
                </td>
              </tr>
            <?php endforeach; ?>
            <?php if (!$rows): ?>
              <tr><td colspan="5" class="text-muted">No vote items yet. Use Seed Starter List to begin.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../partials/footer.php'; ?>
