<?php
require_once __DIR__ . '/../../../app/bootstrap.php';
$u = require_login(); $tid = tenant_id(); $pdo = db();
csrf_check();

// load
$stmt = $pdo->prepare("SELECT * FROM schools WHERE tenant_id=? LIMIT 1");
$stmt->execute([$tid]);
$school = $stmt->fetch();

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $name = trim((string)($_POST['name'] ?? ''));
  $county = trim((string)($_POST['county'] ?? ''));
  $subcounty = trim((string)($_POST['subcounty'] ?? ''));
  $category = trim((string)($_POST['category'] ?? ''));
  $school_type = trim((string)($_POST['school_type'] ?? ''));
  $students = (int)($_POST['students'] ?? 0);
  $streams = (int)($_POST['streams'] ?? 0);
  $contacts = trim((string)($_POST['contacts'] ?? ''));

  if ($school) {
    $pdo->prepare("UPDATE schools SET name=?, county=?, subcounty=?, category=?, school_type=?, students=?, streams=?, contacts=? WHERE tenant_id=?")
      ->execute([$name,$county,$subcounty,$category,$school_type,$students,$streams,$contacts,$tid]);
  } else {
    $pdo->prepare("INSERT INTO schools (tenant_id,name,county,subcounty,category,school_type,students,streams,contacts) VALUES (?,?,?,?,?,?,?,?,?)")
      ->execute([$tid,$name,$county,$subcounty,$category,$school_type,$students,$streams,$contacts]);
  }

  $pdo->prepare("INSERT INTO audit_log (tenant_id,user_id,action,entity,entity_id,details_json) VALUES (?,?,?,?,?,?)")
    ->execute([$tid,(int)$u['id'],'UPSERT','school',0,json_encode(['name'=>$name])]);

  flash("School profile saved.", "success");
  header('Location: school.php'); exit;
}

$stmt->execute([$tid]); $school = $stmt->fetch();

include __DIR__ . '/../../partials/header.php';
?>
<div class="row g-3">
  <div class="col-lg-3"><?php include __DIR__ . '/../../partials/sidebar.php'; ?></div>
  <div class="col-lg-9">
    <div class="card-glass p-4">
      <div class="d-flex justify-content-between align-items-start">
        <div>
          <h4 class="fw-bold mb-1">School Profile</h4>
          <div class="text-muted">Used for the annual report header sections and reporting outputs.</div>
        </div>
        <span class="badge badge-soft">Setup</span>
      </div>
      <hr class="border-0" style="height:1px;background:rgba(255,255,255,.10)">
      <form method="post" class="row g-3">
        <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
        <div class="col-md-8">
          <label class="form-label">School Name</label>
          <input class="form-control" name="name" required value="<?= esc($school['name'] ?? '') ?>" placeholder="XYZ Secondary School">
        </div>
        <div class="col-md-4">
          <label class="form-label">Category</label>
          <select class="form-select" name="category">
            <?php foreach (['National','Extra County','County','Sub County'] as $c): ?>
              <option value="<?= esc($c) ?>" <?= (($school['category']??'')===$c)?'selected':'' ?>><?= esc($c) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-4">
          <label class="form-label">County</label>
          <input class="form-control" name="county" value="<?= esc($school['county'] ?? '') ?>" placeholder="e.g., Nandi">
        </div>
        <div class="col-md-4">
          <label class="form-label">Sub-County</label>
          <input class="form-control" name="subcounty" value="<?= esc($school['subcounty'] ?? '') ?>" placeholder="e.g., Nandi East">
        </div>
        <div class="col-md-4">
          <label class="form-label">Day/Boarding</label>
          <select class="form-select" name="school_type">
            <?php foreach (['Day','Boarding','Day & Boarding'] as $t): ?>
              <option value="<?= esc($t) ?>" <?= (($school['school_type']??'')===$t)?'selected':'' ?>><?= esc($t) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-3">
          <label class="form-label">Students</label>
          <input class="form-control" type="number" min="0" name="students" value="<?= esc($school['students'] ?? 0) ?>">
        </div>
        <div class="col-md-3">
          <label class="form-label">Streams</label>
          <input class="form-control" type="number" min="0" name="streams" value="<?= esc($school['streams'] ?? 0) ?>">
        </div>
        <div class="col-md-6">
          <label class="form-label">Contacts (free text)</label>
          <textarea class="form-control" name="contacts" rows="3" placeholder="P.O. Box..., Tel..., Email..., Website..."><?= esc($school['contacts'] ?? '') ?></textarea>
        </div>
        <div class="col-12 d-flex gap-2">
          <button class="btn btn-accent">Save</button>
          <a class="btn btn-outline-light" href="../../index.php">Back</a>
        </div>
      </form>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../partials/footer.php'; ?>
