<?php
require_once __DIR__ . '/../../../app/bootstrap.php';
$u = require_login(); $tid = tenant_id(); $pdo = db();
csrf_check();

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $label = trim((string)($_POST['label'] ?? ''));
  $start = (string)($_POST['start_date'] ?? '');
  $end   = (string)($_POST['end_date'] ?? '');
  $pdo->prepare("INSERT INTO fiscal_years (tenant_id,label,start_date,end_date,is_closed) VALUES (?,?,?,?,0)")
    ->execute([$tid,$label,$start,$end]);
  flash("Fiscal year created.", "success");
  header('Location: fiscal_years.php'); exit;
}

if (isset($_GET['close'])) {
  $id = (int)$_GET['close'];
  $pdo->prepare("UPDATE fiscal_years SET is_closed=1 WHERE tenant_id=? AND id=?")->execute([$tid,$id]);
  flash("Fiscal year closed (MVP lock).", "warning");
  header('Location: fiscal_years.php'); exit;
}

$st = $pdo->prepare("SELECT * FROM fiscal_years WHERE tenant_id=? ORDER BY start_date DESC");
$st->execute([$tid]);
$rows = $st->fetchAll();

include __DIR__ . '/../../partials/header.php';
?>
<div class="row g-3">
  <div class="col-lg-3"><?php include __DIR__ . '/../../partials/sidebar.php'; ?></div>
  <div class="col-lg-9">
    <div class="card-glass p-4 mb-3">
      <h4 class="fw-bold mb-1">Fiscal Years</h4>
      <div class="text-muted">Create FY 2024/25 + comparative FY for IPSAS reporting.</div>
      <hr class="border-0" style="height:1px;background:rgba(255,255,255,.10)">
      <form method="post" class="row g-2 align-items-end">
        <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
        <div class="col-md-4">
          <label class="form-label">Label</label>
          <input class="form-control" name="label" required placeholder="FY 2024/25">
        </div>
        <div class="col-md-3">
          <label class="form-label">Start</label>
          <input class="form-control" type="date" name="start_date" required>
        </div>
        <div class="col-md-3">
          <label class="form-label">End</label>
          <input class="form-control" type="date" name="end_date" required>
        </div>
        <div class="col-md-2">
          <button class="btn btn-accent w-100">Create</button>
        </div>
      </form>
    </div>

    <div class="card-glass p-3">
      <div class="fw-bold mb-2">Years</div>
      <div class="table-responsive">
        <table class="table table-darkish table-hover align-middle">
          <thead><tr><th>Label</th><th>Start</th><th>End</th><th>Status</th><th></th></tr></thead>
          <tbody>
            <?php foreach ($rows as $r): ?>
              <tr>
                <td><?= esc($r['label']) ?></td>
                <td><?= esc($r['start_date']) ?></td>
                <td><?= esc($r['end_date']) ?></td>
                <td>
                  <?php if ((int)$r['is_closed']===1): ?>
                    <span class="badge badge-soft">Closed</span>
                  <?php else: ?>
                    <span class="badge badge-soft">Open</span>
                  <?php endif; ?>
                </td>
                <td class="text-end">
                  <?php if ((int)$r['is_closed']===0): ?>
                    <a class="btn btn-sm btn-outline-light" href="?close=<?= (int)$r['id'] ?>" onclick="return confirm('Close this FY? (MVP lock)')">Close</a>
                  <?php endif; ?>
                </td>
              </tr>
            <?php endforeach; ?>
            <?php if (!$rows): ?>
              <tr><td colspan="5" class="text-muted">No fiscal years yet.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../partials/footer.php'; ?>
