<?php
require_once __DIR__ . '/../../../app/bootstrap.php';
$u = require_login(); $tid = tenant_id(); $pdo = db();
csrf_check();

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $date = (string)($_POST['as_at_date'] ?? date('Y-m-d'));
  $amount = (float)($_POST['amount'] ?? 0);
  $pdo->prepare("INSERT INTO cash_drawer (tenant_id,as_at_date,amount) VALUES (?,?,?)
                 ON DUPLICATE KEY UPDATE amount=VALUES(amount)")->execute([$tid,$date,$amount]);
  flash("Cash position saved for $date.", "success");
  header("Location: cash_positions.php"); exit;
}

$st = $pdo->prepare("SELECT * FROM cash_drawer WHERE tenant_id=? ORDER BY as_at_date DESC LIMIT 60");
$st->execute([$tid]);
$rows = $st->fetchAll();

include __DIR__ . '/../../partials/header.php';
?>
<div class="row g-3">
  <div class="col-lg-3"><?php include __DIR__ . '/../../partials/sidebar.php'; ?></div>
  <div class="col-lg-9">
    <div class="card-glass p-4 mb-3">
      <h4 class="fw-bold mb-1">Cash Positions</h4>
      <div class="text-muted">Set cash-in-hand balances (used in Statement of Financial Position & Cash Flow).</div>
      <hr class="border-0" style="height:1px;background:rgba(255,255,255,.10)">
      <form method="post" class="row g-2 align-items-end">
        <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
        <div class="col-md-4">
          <label class="form-label">As at date</label>
          <input class="form-control" type="date" name="as_at_date" value="<?= esc(date('Y-m-d')) ?>" required>
        </div>
        <div class="col-md-4">
          <label class="form-label">Cash in hand (KSh)</label>
          <input class="form-control" type="number" step="0.01" name="amount" value="0" required>
        </div>
        <div class="col-md-4">
          <button class="btn btn-accent w-100">Save</button>
        </div>
      </form>
    </div>

    <div class="card-glass p-3">
      <div class="fw-bold mb-2">Recent cash positions</div>
      <div class="table-responsive">
        <table class="table table-darkish table-hover align-middle">
          <thead><tr><th>Date</th><th class="text-end">Cash in hand</th></tr></thead>
          <tbody>
            <?php foreach ($rows as $r): ?>
              <tr>
                <td><?= esc($r['as_at_date']) ?></td>
                <td class="text-end">KSh <?= esc(money($r['amount'])) ?></td>
              </tr>
            <?php endforeach; ?>
            <?php if (!$rows): ?>
              <tr><td colspan="2" class="text-muted">No cash positions recorded yet.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../partials/footer.php'; ?>
