<?php
require_once __DIR__ . '/../../../app/bootstrap.php';
$u = require_login(); $tid = tenant_id(); $pdo = db();
csrf_check();

if ($_SERVER['REQUEST_METHOD']==='POST' && ($_POST['action'] ?? '')==='add') {
  $name = trim((string)($_POST['name'] ?? ''));
  $bank = trim((string)($_POST['bank'] ?? ''));
  $branch = trim((string)($_POST['branch'] ?? ''));
  $acct = trim((string)($_POST['account_no'] ?? ''));
  $status = (string)($_POST['status'] ?? 'Active');
  $balance = (float)($_POST['balance'] ?? 0);

  $pdo->prepare("INSERT INTO bank_accounts (tenant_id,name,bank,branch,account_no,status,balance) VALUES (?,?,?,?,?,?,?)")
    ->execute([$tid,$name,$bank,$branch,$acct,$status,$balance]);

  $pdo->prepare("INSERT INTO audit_log (tenant_id,user_id,action,entity,entity_id,details_json) VALUES (?,?,?,?,?,?)")
    ->execute([$tid,(int)$u['id'],'CREATE','bank_account',0,json_encode(['name'=>$name])]);

  flash("Bank account added.", "success");
  header('Location: banks.php'); exit;
}

if (isset($_GET['del'])) {
  $id = (int)$_GET['del'];
  $pdo->prepare("DELETE FROM bank_accounts WHERE tenant_id=? AND id=?")->execute([$tid,$id]);
  flash("Bank account deleted.", "warning");
  header('Location: banks.php'); exit;
}

$rows = $pdo->prepare("SELECT * FROM bank_accounts WHERE tenant_id=? ORDER BY id DESC");
$rows->execute([$tid]);
$rows = $rows->fetchAll();

include __DIR__ . '/../../partials/header.php';
?>
<div class="row g-3">
  <div class="col-lg-3"><?php include __DIR__ . '/../../partials/sidebar.php'; ?></div>
  <div class="col-lg-9">
    <div class="card-glass p-4 mb-3">
      <div class="d-flex justify-content-between align-items-start">
        <div>
          <h4 class="fw-bold mb-1">Bank Accounts</h4>
          <div class="text-muted">These appear in the reporting notes (bank balances listing).</div>
        </div>
        <span class="badge badge-soft">Setup</span>
      </div>

      <hr class="border-0" style="height:1px;background:rgba(255,255,255,.10)">

      <form method="post" class="row g-2 align-items-end">
        <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
        <input type="hidden" name="action" value="add">
        <div class="col-md-3">
          <label class="form-label">Account Name</label>
          <input class="form-control" name="name" required placeholder="Tuition Account">
        </div>
        <div class="col-md-2">
          <label class="form-label">Bank</label>
          <input class="form-control" name="bank" placeholder="KCB / Equity">
        </div>
        <div class="col-md-2">
          <label class="form-label">Branch</label>
          <input class="form-control" name="branch" placeholder="Town">
        </div>
        <div class="col-md-2">
          <label class="form-label">Account No</label>
          <input class="form-control" name="account_no" placeholder="123...">
        </div>
        <div class="col-md-1">
          <label class="form-label">Status</label>
          <select class="form-select" name="status">
            <option>Active</option>
            <option>Dormant</option>
          </select>
        </div>
        <div class="col-md-2">
          <label class="form-label">Opening Balance</label>
          <input class="form-control" name="balance" type="number" step="0.01" value="0">
        </div>
        <div class="col-12">
          <button class="btn btn-accent">Add Account</button>
        </div>
      </form>
    </div>

    <div class="card-glass p-3">
      <div class="fw-bold mb-2">Accounts</div>
      <div class="table-responsive">
        <table class="table table-darkish table-hover align-middle">
          <thead>
            <tr>
              <th>Name</th><th>Bank</th><th>Branch</th><th>Account No</th><th>Status</th><th class="text-end">Balance</th><th></th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($rows as $r): ?>
              <tr>
                <td><?= esc($r['name']) ?></td>
                <td><?= esc($r['bank']) ?></td>
                <td><?= esc($r['branch']) ?></td>
                <td><?= esc($r['account_no']) ?></td>
                <td><span class="badge badge-soft"><?= esc($r['status']) ?></span></td>
                <td class="text-end">KSh <?= esc(money($r['balance'])) ?></td>
                <td class="text-end">
                  <a class="btn btn-sm btn-outline-light" href="?del=<?= (int)$r['id'] ?>" onclick="return confirm('Delete this account?')">Delete</a>
                </td>
              </tr>
            <?php endforeach; ?>
            <?php if (!$rows): ?>
              <tr><td colspan="7" class="text-muted">No bank accounts yet.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../partials/footer.php'; ?>
