<?php
require_once __DIR__ . '/../../../app/bootstrap.php';
$u = require_login(); $tid = tenant_id(); $pdo = db();

$fys = $pdo->prepare("SELECT id,label,start_date,end_date FROM fiscal_years WHERE tenant_id=? ORDER BY start_date DESC");
$fys->execute([$tid]); $fys = $fys->fetchAll();
$fy_id = (int)($_GET['fy'] ?? ($fys[0]['id'] ?? 0));

$school = $pdo->prepare("SELECT * FROM schools WHERE tenant_id=? LIMIT 1");
$school->execute([$tid]); $school = $school->fetch();

$fy = null;
foreach ($fys as $x) if ((int)$x['id']===$fy_id) $fy = $x;

function sum_by_note(PDO $pdo, int $tid, int $fy_id, string $table, string $line_table, string $join_col, string $amount_col, string $note_no, bool $is_receipt): float {
  // note_no is stored in vote_items.note_no
  $sql = "
    SELECT COALESCE(SUM(l.$amount_col),0) amt
    FROM {$line_table} l
    JOIN {$table} t ON t.id = l.{$join_col}
    JOIN vote_items v ON v.id = l.vote_item_id
    WHERE t.tenant_id=? AND t.fiscal_year_id=? AND v.note_no=?
  ";
  $st = $pdo->prepare($sql);
  $st->execute([$tid,$fy_id,$note_no]);
  return (float)($st->fetchColumn() ?? 0);
}

function sum_group(PDO $pdo, int $tid, int $fy_id, array $groups, bool $is_receipts): float {
  $in = implode(",", array_fill(0, count($groups), "?"));
  $sql = $is_receipts
    ? "SELECT COALESCE(SUM(rl.amount),0) FROM receipt_lines rl JOIN receipts r ON r.id=rl.receipt_id JOIN vote_items v ON v.id=rl.vote_item_id
       WHERE r.tenant_id=? AND r.fiscal_year_id=? AND v.grp IN ($in)"
    : "SELECT COALESCE(SUM(pl.amount),0) FROM payment_lines pl JOIN payments p ON p.id=pl.payment_id JOIN vote_items v ON v.id=pl.vote_item_id
       WHERE p.tenant_id=? AND p.fiscal_year_id=? AND v.grp IN ($in)";
  $params = array_merge([$tid,$fy_id], $groups);
  $st = $pdo->prepare($sql);
  $st->execute($params);
  return (float)($st->fetchColumn() ?? 0);
}

$rev_total = sum_group($pdo,$tid,$fy_id,['Revenue'],true);
$exp_tuition = sum_group($pdo,$tid,$fy_id,['Tuition'],false);
$exp_ops = sum_group($pdo,$tid,$fy_id,['Operations'],false);
$exp_infra = sum_group($pdo,$tid,$fy_id,['Infrastructure'],false);
$exp_sf = sum_group($pdo,$tid,$fy_id,['School Fund'],false);
$exp_total = $exp_tuition + $exp_ops + $exp_infra + $exp_sf;
$surplus = $rev_total - $exp_total;

$bank_total = (float)($pdo->prepare("SELECT COALESCE(SUM(balance),0) FROM bank_accounts WHERE tenant_id=?")->execute([$tid]) ?: 0);
// compute properly
$st = $pdo->prepare("SELECT COALESCE(SUM(balance),0) FROM bank_accounts WHERE tenant_id=?"); $st->execute([$tid]); $bank_total = (float)$st->fetchColumn();

$st = $pdo->prepare("SELECT COALESCE(SUM(amount),0) FROM cash_drawer WHERE tenant_id=? AND as_at_date=CURDATE()"); $st->execute([$tid]);
$cash_today = (float)$st->fetchColumn();

$st = $pdo->prepare("SELECT COALESCE(SUM(balance),0) FROM receivables WHERE tenant_id=?"); $st->execute([$tid]); $recv = (float)$st->fetchColumn();
$st = $pdo->prepare("SELECT COALESCE(SUM(balance),0) FROM payables WHERE tenant_id=?"); $st->execute([$tid]); $payb = (float)$st->fetchColumn();

$banks = $pdo->prepare("SELECT * FROM bank_accounts WHERE tenant_id=? ORDER BY name");
$banks->execute([$tid]); $banks = $banks->fetchAll();

include __DIR__ . '/../../partials/header.php';
?>
<div class="row g-3">
  <div class="col-lg-3"><?php include __DIR__ . '/../../partials/sidebar.php'; ?></div>
  <div class="col-lg-9">
    <div class="card-glass p-4 mb-3">
      <div class="d-flex justify-content-between align-items-start">
        <div>
          <h4 class="fw-bold mb-1">IPSAS Pack (HTML Preview)</h4>
          <div class="text-muted">This MVP generates the core statements in HTML aligned to the template structure.</div>
        </div>
        <form method="get" class="d-flex gap-2">
          <select class="form-select" name="fy" onchange="this.form.submit()">
            <?php foreach ($fys as $x): ?>
              <option value="<?= (int)$x['id'] ?>" <?= ($fy_id==(int)$x['id'])?'selected':'' ?>><?= esc($x['label']) ?></option>
            <?php endforeach; ?>
          </select>
          <button class="btn btn-outline-light" type="button" onclick="window.print()">Print</button>
        </form>
      </div>
    </div>

    <div class="card-glass p-4">
      <div class="text-center mb-3">
        <div class="text-muted small">Annual Report and Financial Statements</div>
        <div class="fw-bold" style="font-size:1.25rem;letter-spacing:-.02em;"><?= esc($school['name'] ?? 'Your School') ?></div>
        <div class="text-muted">For the year ended <?= esc($fy['end_date'] ?? '') ?></div>
        <div class="text-muted small mt-2">Transitional Financial Statements Prepared under IPSAS</div>
      </div>

      <h5 class="fw-bold mt-4">Statement of Financial Performance</h5>
      <div class="table-responsive">
        <table class="table table-darkish align-middle">
          <thead><tr><th>Description</th><th class="text-end">KSh</th></tr></thead>
          <tbody>
            <tr><td class="text-muted">Total Revenue</td><td class="text-end fw-bold"><?= esc(money($rev_total)) ?></td></tr>
            <tr><td class="text-muted">Tuition</td><td class="text-end"><?= esc(money($exp_tuition)) ?></td></tr>
            <tr><td class="text-muted">Operations</td><td class="text-end"><?= esc(money($exp_ops)) ?></td></tr>
            <tr><td class="text-muted">Infrastructure</td><td class="text-end"><?= esc(money($exp_infra)) ?></td></tr>
            <tr><td class="text-muted">Boarding/School Fund</td><td class="text-end"><?= esc(money($exp_sf)) ?></td></tr>
            <tr><td class="text-muted">Total Expenditure</td><td class="text-end fw-bold"><?= esc(money($exp_total)) ?></td></tr>
            <tr><td class="text-muted">Surplus / (Deficit)</td><td class="text-end fw-bold"><?= esc(money($surplus)) ?></td></tr>
          </tbody>
        </table>
      </div>

      <h5 class="fw-bold mt-4">Statement of Assets and Liabilities</h5>
      <div class="table-responsive">
        <table class="table table-darkish align-middle">
          <thead><tr><th>Description</th><th class="text-end">KSh</th></tr></thead>
          <tbody>
            <tr><td class="text-muted">Bank balances</td><td class="text-end"><?= esc(money($bank_total)) ?></td></tr>
            <tr><td class="text-muted">Cash balances (today)</td><td class="text-end"><?= esc(money($cash_today)) ?></td></tr>
            <tr><td class="text-muted">Accounts receivable</td><td class="text-end"><?= esc(money($recv)) ?></td></tr>
            <tr><td class="text-muted">Accounts payable</td><td class="text-end"><?= esc(money($payb)) ?></td></tr>
            <tr><td class="text-muted">Net financial assets</td><td class="text-end fw-bold"><?= esc(money(($bank_total+$cash_today+$recv)-$payb)) ?></td></tr>
          </tbody>
        </table>
      </div>

      <h6 class="fw-bold mt-4">Note: Bank Accounts Listing</h6>
      <div class="table-responsive">
        <table class="table table-darkish table-hover align-middle">
          <thead><tr><th>Account</th><th>Bank</th><th>Branch</th><th>Status</th><th class="text-end">Balance</th></tr></thead>
          <tbody>
            <?php foreach ($banks as $b): ?>
              <tr>
                <td><?= esc($b['name']) ?></td>
                <td><?= esc($b['bank']) ?></td>
                <td><?= esc($b['branch']) ?></td>
                <td><span class="badge badge-soft"><?= esc($b['status']) ?></span></td>
                <td class="text-end"><?= esc(money($b['balance'])) ?></td>
              </tr>
            <?php endforeach; ?>
            <?php if (!$banks): ?>
              <tr><td colspan="5" class="text-muted">No bank accounts yet.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>

      <div class="text-muted small mt-3">
        MVP note: Add PDF export + full template narrative sections (BOM, committees, policies) in Phase 1.1.
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../partials/footer.php'; ?>
