<?php
require_once __DIR__ . '/../../../app/bootstrap.php';
$u = require_login(); $tid = tenant_id(); $pdo = db();

$fys = $pdo->prepare("SELECT id,label,start_date,end_date FROM fiscal_years WHERE tenant_id=? ORDER BY start_date DESC");
$fys->execute([$tid]); $fys = $fys->fetchAll();
$fy_id = (int)($_GET['fy'] ?? ($fys[0]['id'] ?? 0));
$fy = null;
foreach ($fys as $x) if ((int)$x['id']===$fy_id) $fy=$x;

function sum_receipts(PDO $pdo, int $tid, int $fy_id): float {
  $st = $pdo->prepare("SELECT COALESCE(SUM(total_amount),0) FROM receipts WHERE tenant_id=? AND fiscal_year_id=?");
  $st->execute([$tid,$fy_id]);
  return (float)$st->fetchColumn();
}
function sum_payments(PDO $pdo, int $tid, int $fy_id): float {
  $st = $pdo->prepare("SELECT COALESCE(SUM(total_amount),0) FROM payments WHERE tenant_id=? AND fiscal_year_id=?");
  $st->execute([$tid,$fy_id]);
  return (float)$st->fetchColumn();
}

$inflows = sum_receipts($pdo,$tid,$fy_id);
$outflows = sum_payments($pdo,$tid,$fy_id);
$net = $inflows - $outflows;

$st = $pdo->prepare("SELECT COALESCE(SUM(balance),0) FROM bank_accounts WHERE tenant_id=?");
$st->execute([$tid]); $bank = (float)$st->fetchColumn();

// cash at FY end date (best effort): use cash_drawer at fy end date; fallback today
$cash = 0.0;
if ($fy && !empty($fy['end_date'])){
  $st = $pdo->prepare("SELECT amount FROM cash_drawer WHERE tenant_id=? AND as_at_date=?");
  $st->execute([$tid,$fy['end_date']]);
  $cash = (float)($st->fetchColumn() ?? 0);
} else {
  $st = $pdo->prepare("SELECT COALESCE(SUM(amount),0) FROM cash_drawer WHERE tenant_id=? AND as_at_date=CURDATE()");
  $st->execute([$tid]); $cash = (float)$st->fetchColumn();
}

$closing = $bank + $cash;

include __DIR__ . '/../../partials/header.php';
?>
<div class="row g-3">
  <div class="col-lg-3"><?php include __DIR__ . '/../../partials/sidebar.php'; ?></div>
  <div class="col-lg-9">
    <div class="card-glass p-4 mb-3">
      <div class="d-flex justify-content-between align-items-start">
        <div>
          <h4 class="fw-bold mb-1">Statement of Cash Flows (Direct Method)</h4>
          <div class="text-muted">FY-based summary from receipts/payments, reconciled to closing cash & bank.</div>
        </div>
        <form method="get" class="d-flex gap-2">
          <select class="form-select" name="fy" onchange="this.form.submit()">
            <?php foreach ($fys as $x): ?>
              <option value="<?= (int)$x['id'] ?>" <?= ($fy_id==(int)$x['id'])?'selected':'' ?>><?= esc($x['label']) ?></option>
            <?php endforeach; ?>
          </select>
          <button class="btn btn-outline-light" type="button" onclick="window.print()">Print</button>
        </form>
      </div>
    </div>

    <div class="card-glass p-4">
      <div class="table-responsive">
        <table class="table table-darkish align-middle">
          <thead><tr><th>Description</th><th class="text-end">KSh</th></tr></thead>
          <tbody>
            <tr><td class="text-muted">Cash inflows (total receipts)</td><td class="text-end fw-bold"><?= esc(money($inflows)) ?></td></tr>
            <tr><td class="text-muted">Cash outflows (total payments)</td><td class="text-end fw-bold"><?= esc(money($outflows)) ?></td></tr>
            <tr><td class="text-muted">Net cash from operating activities</td><td class="text-end fw-bold"><?= esc(money($net)) ?></td></tr>
            <tr><td class="text-muted">Closing bank balances (all accounts)</td><td class="text-end"><?= esc(money($bank)) ?></td></tr>
            <tr><td class="text-muted">Closing cash in hand</td><td class="text-end"><?= esc(money($cash)) ?></td></tr>
            <tr><td class="text-muted">Closing cash & cash equivalents</td><td class="text-end fw-bold"><?= esc(money($closing)) ?></td></tr>
          </tbody>
        </table>
      </div>
      <div class="text-muted small">
        MVP note: For full ministry pack, we can split inflows/outflows into detailed lines (grants, fees, other income; tuition/ops/infra/school fund).
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../partials/footer.php'; ?>
