<?php
require_once __DIR__ . '/../../../app/bootstrap.php';
$u = require_login(); $tid = tenant_id(); $pdo = db();

$rows = $pdo->prepare("SELECT * FROM payables WHERE tenant_id=? ORDER BY first_date ASC");
$rows->execute([$tid]);
$rows = $rows->fetchAll();

function ageing_bucket(string $first_date): string {
  $d1 = new DateTime($first_date);
  $now = new DateTime();
  $days = (int)$now->diff($d1)->format('%a');
  if ($days < 365) return "< 1 year";
  if ($days < 730) return "1–2 years";
  if ($days < 1095) return "2–3 years";
  return "> 3 years";
}

include __DIR__ . '/../../partials/header.php';
?>
<div class="row g-3">
  <div class="col-lg-3"><?php include __DIR__ . '/../../partials/sidebar.php'; ?></div>
  <div class="col-lg-9">
    <div class="card-glass p-4 mb-3">
      <div class="d-flex justify-content-between align-items-start">
        <div>
          <h4 class="fw-bold mb-1">Annex I: Pending Payables Schedule</h4>
          <div class="text-muted">Supplier-wise pending amounts with ageing (print/export).</div>
        </div>
        <div class="d-flex gap-2">
          <a class="btn btn-outline-light" href="../finance/payables.php">Update payables</a>
          <button class="btn btn-outline-light" type="button" onclick="window.print()">Print</button>
        </div>
      </div>
    </div>

    <div class="card-glass p-3">
      <div class="table-responsive">
        <table class="table table-darkish table-hover align-middle">
          <thead><tr><th>Supplier/Creditor</th><th>First date</th><th>Last date</th><th>Age</th><th class="text-end">Amount (KSh)</th></tr></thead>
          <tbody>
            <?php foreach ($rows as $r): ?>
              <tr>
                <td><?= esc($r['supplier']) ?></td>
                <td class="text-muted"><?= esc($r['first_date']) ?></td>
                <td class="text-muted"><?= esc($r['last_date']) ?></td>
                <td><span class="badge badge-soft"><?= esc(ageing_bucket($r['first_date'])) ?></span></td>
                <td class="text-end fw-bold"><?= esc(money($r['balance'])) ?></td>
              </tr>
            <?php endforeach; ?>
            <?php if (!$rows): ?>
              <tr><td colspan="5" class="text-muted">No payables recorded.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
      <div class="text-muted small">Tip: Use browser “Print → Save as PDF” for a ministry-ready PDF.</div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../partials/footer.php'; ?>
