<?php
require_once __DIR__ . '/../../../app/bootstrap.php';
$u = require_login(); $tid = tenant_id(); $pdo = db();

$st = $pdo->prepare("SELECT asset_class, COUNT(*) cnt, COALESCE(SUM(cost),0) total_cost FROM assets WHERE tenant_id=? GROUP BY asset_class ORDER BY asset_class");
$st->execute([$tid]);
$summary = $st->fetchAll();

$rows = $pdo->prepare("SELECT * FROM assets WHERE tenant_id=? ORDER BY asset_class, asset_name");
$rows->execute([$tid]);
$rows = $rows->fetchAll();

include __DIR__ . '/../../partials/header.php';
?>
<div class="row g-3">
  <div class="col-lg-3"><?php include __DIR__ . '/../../partials/sidebar.php'; ?></div>
  <div class="col-lg-9">
    <div class="card-glass p-4 mb-3">
      <div class="d-flex justify-content-between align-items-start">
        <div>
          <h4 class="fw-bold mb-1">Annex II: Fixed Assets Summary</h4>
          <div class="text-muted">Class summary + detailed register (print/export).</div>
        </div>
        <div class="d-flex gap-2">
          <a class="btn btn-outline-light" href="../assets/assets.php">Update assets</a>
          <button class="btn btn-outline-light" type="button" onclick="window.print()">Print</button>
        </div>
      </div>
    </div>

    <div class="card-glass p-3 mb-3">
      <div class="fw-bold mb-2">Summary by class</div>
      <div class="table-responsive">
        <table class="table table-darkish table-hover align-middle">
          <thead><tr><th>Class</th><th class="text-end">Count</th><th class="text-end">Total Cost (KSh)</th></tr></thead>
          <tbody>
            <?php foreach ($summary as $s): ?>
              <tr>
                <td><span class="badge badge-soft"><?= esc($s['asset_class']) ?></span></td>
                <td class="text-end"><?= (int)$s['cnt'] ?></td>
                <td class="text-end fw-bold"><?= esc(money($s['total_cost'])) ?></td>
              </tr>
            <?php endforeach; ?>
            <?php if (!$summary): ?>
              <tr><td colspan="3" class="text-muted">No assets recorded.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>

    <div class="card-glass p-3">
      <div class="fw-bold mb-2">Detailed register</div>
      <div class="table-responsive">
        <table class="table table-darkish table-hover align-middle">
          <thead><tr><th>Class</th><th>Asset</th><th>Acq date</th><th class="text-end">Cost</th><th>Condition</th><th>Location</th></tr></thead>
          <tbody>
            <?php foreach ($rows as $r): ?>
              <tr>
                <td><span class="badge badge-soft"><?= esc($r['asset_class']) ?></span></td>
                <td><?= esc($r['asset_name']) ?></td>
                <td class="text-muted"><?= esc($r['acq_date'] ?? '') ?></td>
                <td class="text-end fw-bold"><?= esc(money($r['cost'])) ?></td>
                <td class="text-muted"><?= esc($r['asset_condition']) ?></td>
                <td class="text-muted"><?= esc($r['location']) ?></td>
              </tr>
            <?php endforeach; ?>
            <?php if (!$rows): ?>
              <tr><td colspan="6" class="text-muted">No assets recorded.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
      <div class="text-muted small">Tip: Use browser “Print → Save as PDF” for a ministry-ready PDF.</div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../partials/footer.php'; ?>
