<?php
require_once __DIR__ . '/../../../app/bootstrap.php';
$u = require_login(); $tid = tenant_id(); $pdo = db();
csrf_check();

$sources = ['MoE','Parents/School Fund','NG-CDF','County Government','Donor','IGA','Other'];

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $name = trim((string)($_POST['name'] ?? ''));
  $source = trim((string)($_POST['funding_source'] ?? 'Other'));
  $start = (string)($_POST['start_date'] ?? '');
  $status = trim((string)($_POST['status'] ?? 'Planned'));
  $budget = (float)($_POST['budget'] ?? 0);
  $spent = (float)($_POST['spent'] ?? 0);

  if ($name !== '') {
    $pdo->prepare("INSERT INTO projects (tenant_id,name,funding_source,start_date,status,budget,spent) VALUES (?,?,?,?,?,?,?)")
        ->execute([$tid,$name,$source,$start?:null,$status,$budget,$spent]);
    flash("Project saved.", "success");
    header("Location: projects.php"); exit;
  }
  flash("Project name is required.", "danger");
}

if (isset($_GET['del'])) {
  $id = (int)$_GET['del'];
  $pdo->prepare("DELETE FROM projects WHERE tenant_id=? AND id=?")->execute([$tid,$id]);
  flash("Deleted.", "warning");
  header("Location: projects.php"); exit;
}

$st = $pdo->prepare("SELECT * FROM projects WHERE tenant_id=? ORDER BY id DESC");
$st->execute([$tid]);
$rows = $st->fetchAll();

include __DIR__ . '/../../partials/header.php';
?>
<div class="row g-3">
  <div class="col-lg-3"><?php include __DIR__ . '/../../partials/sidebar.php'; ?></div>
  <div class="col-lg-9">
    <div class="card-glass p-4 mb-3">
      <h4 class="fw-bold mb-1">Projects & Development Register</h4>
      <div class="text-muted">Supports the annual report “Development Projects” section.</div>
      <hr class="border-0" style="height:1px;background:rgba(255,255,255,.10)">
      <form method="post" class="row g-2 align-items-end">
        <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
        <div class="col-md-4">
          <label class="form-label">Project</label>
          <input class="form-control" name="name" required placeholder="e.g., Classroom block, Lab renovation">
        </div>
        <div class="col-md-2">
          <label class="form-label">Funding source</label>
          <select class="form-select" name="funding_source">
            <?php foreach ($sources as $s): ?><option value="<?= esc($s) ?>"><?= esc($s) ?></option><?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-2">
          <label class="form-label">Start date</label>
          <input class="form-control" type="date" name="start_date">
        </div>
        <div class="col-md-2">
          <label class="form-label">Status</label>
          <input class="form-control" name="status" placeholder="Planned / Ongoing / Completed" value="Planned">
        </div>
        <div class="col-md-1">
          <label class="form-label">Budget</label>
          <input class="form-control" type="number" step="0.01" name="budget" value="0">
        </div>
        <div class="col-md-1">
          <label class="form-label">Spent</label>
          <input class="form-control" type="number" step="0.01" name="spent" value="0">
        </div>
        <div class="col-12">
          <button class="btn btn-accent">Add Project</button>
        </div>
      </form>
    </div>

    <div class="card-glass p-3">
      <div class="table-responsive">
        <table class="table table-darkish table-hover align-middle">
          <thead><tr><th>Project</th><th>Source</th><th>Start</th><th>Status</th><th class="text-end">Budget</th><th class="text-end">Spent</th><th class="text-end">Balance</th><th></th></tr></thead>
          <tbody>
            <?php foreach ($rows as $r): $bal = (float)$r['budget']-(float)$r['spent']; ?>
              <tr>
                <td><?= esc($r['name']) ?></td>
                <td><span class="badge badge-soft"><?= esc($r['funding_source']) ?></span></td>
                <td class="text-muted"><?= esc($r['start_date'] ?? '') ?></td>
                <td class="text-muted"><?= esc($r['status']) ?></td>
                <td class="text-end"><?= esc(money($r['budget'])) ?></td>
                <td class="text-end"><?= esc(money($r['spent'])) ?></td>
                <td class="text-end fw-bold"><?= esc(money($bal)) ?></td>
                <td class="text-end">
                  <a class="btn btn-sm btn-outline-light" href="?del=<?= (int)$r['id'] ?>" onclick="return confirm('Delete?')">Delete</a>
                </td>
              </tr>
            <?php endforeach; ?>
            <?php if (!$rows): ?>
              <tr><td colspan="8" class="text-muted">No projects recorded yet.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../partials/footer.php'; ?>
