<?php
require_once __DIR__ . '/../../../app/bootstrap.php';
$u = require_login(); $tid = tenant_id(); $pdo = db();
csrf_check();

$committees = ['Finance & Procurement','Audit','Development','Academic','Discipline/Welfare','Other'];

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $committee = trim((string)($_POST['committee'] ?? 'Other'));
  $meeting_date = (string)($_POST['meeting_date'] ?? date('Y-m-d'));
  $agenda = trim((string)($_POST['agenda'] ?? ''));
  $minutes = trim((string)($_POST['minutes'] ?? ''));
  $pdo->prepare("INSERT INTO committee_meetings (tenant_id,committee,meeting_date,agenda,minutes) VALUES (?,?,?,?,?)")
      ->execute([$tid,$committee,$meeting_date,$agenda,$minutes]);
  flash("Meeting recorded.", "success");
  header("Location: committee_meetings.php"); exit;
}

if (isset($_GET['del'])) {
  $id = (int)$_GET['del'];
  $pdo->prepare("DELETE FROM committee_meetings WHERE tenant_id=? AND id=?")->execute([$tid,$id]);
  flash("Deleted.", "warning");
  header("Location: committee_meetings.php"); exit;
}

$st = $pdo->prepare("SELECT * FROM committee_meetings WHERE tenant_id=? ORDER BY meeting_date DESC, id DESC LIMIT 200");
$st->execute([$tid]);
$rows = $st->fetchAll();

include __DIR__ . '/../../partials/header.php';
?>
<div class="row g-3">
  <div class="col-lg-3"><?php include __DIR__ . '/../../partials/sidebar.php'; ?></div>
  <div class="col-lg-9">
    <div class="card-glass p-4 mb-3">
      <h4 class="fw-bold mb-1">Committees & Meetings</h4>
      <div class="text-muted">Keep committee meeting records for governance reporting.</div>
      <hr class="border-0" style="height:1px;background:rgba(255,255,255,.10)">
      <form method="post" class="row g-2">
        <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
        <div class="col-md-4">
          <label class="form-label">Committee</label>
          <select class="form-select" name="committee">
            <?php foreach ($committees as $c): ?>
              <option value="<?= esc($c) ?>"><?= esc($c) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-2">
          <label class="form-label">Meeting date</label>
          <input class="form-control" type="date" name="meeting_date" value="<?= esc(date('Y-m-d')) ?>" required>
        </div>
        <div class="col-md-6">
          <label class="form-label">Agenda</label>
          <input class="form-control" name="agenda" placeholder="Short agenda">
        </div>
        <div class="col-12">
          <label class="form-label">Minutes / Key Resolutions</label>
          <textarea class="form-control" name="minutes" rows="3" placeholder="Key resolutions, approvals, decisions..."></textarea>
        </div>
        <div class="col-12">
          <button class="btn btn-accent">Save Meeting</button>
        </div>
      </form>
    </div>

    <div class="card-glass p-3">
      <div class="table-responsive">
        <table class="table table-darkish table-hover align-middle">
          <thead><tr><th>Date</th><th>Committee</th><th>Agenda</th><th></th></tr></thead>
          <tbody>
            <?php foreach ($rows as $r): ?>
              <tr>
                <td><?= esc($r['meeting_date']) ?></td>
                <td><span class="badge badge-soft"><?= esc($r['committee']) ?></span></td>
                <td class="text-muted"><?= esc($r['agenda']) ?></td>
                <td class="text-end">
                  <button class="btn btn-sm btn-outline-light" type="button" data-bs-toggle="collapse" data-bs-target="#m<?= (int)$r['id'] ?>">View</button>
                  <a class="btn btn-sm btn-outline-light" href="?del=<?= (int)$r['id'] ?>" onclick="return confirm('Delete?')">Delete</a>
                </td>
              </tr>
              <tr class="collapse" id="m<?= (int)$r['id'] ?>">
                <td colspan="4" class="text-muted small"><?= nl2br(esc($r['minutes'])) ?></td>
              </tr>
            <?php endforeach; ?>
            <?php if (!$rows): ?>
              <tr><td colspan="4" class="text-muted">No meetings yet.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../partials/footer.php'; ?>
