<?php
require_once __DIR__ . '/../../../app/bootstrap.php';
$u = require_login(); $tid = tenant_id(); $pdo = db();
csrf_check();

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $name = trim((string)($_POST['name'] ?? ''));
  $position = trim((string)($_POST['position'] ?? ''));
  $phone = trim((string)($_POST['phone'] ?? ''));
  $term_from = (string)($_POST['term_from'] ?? '');
  $term_to = (string)($_POST['term_to'] ?? '');
  if ($name !== '') {
    $pdo->prepare("INSERT INTO bom_members (tenant_id,name,position,phone,term_from,term_to) VALUES (?,?,?,?,?,?)")
        ->execute([$tid,$name,$position,$phone,$term_from?:null,$term_to?:null]);
    flash("BOM member added.", "success");
    header("Location: bom_members.php"); exit;
  }
  flash("Name is required.", "danger");
}

if (isset($_GET['del'])) {
  $id = (int)$_GET['del'];
  $pdo->prepare("DELETE FROM bom_members WHERE tenant_id=? AND id=?")->execute([$tid,$id]);
  flash("Deleted.", "warning");
  header("Location: bom_members.php"); exit;
}

$st = $pdo->prepare("SELECT * FROM bom_members WHERE tenant_id=? ORDER BY id DESC");
$st->execute([$tid]);
$rows = $st->fetchAll();

include __DIR__ . '/../../partials/header.php';
?>
<div class="row g-3">
  <div class="col-lg-3"><?php include __DIR__ . '/../../partials/sidebar.php'; ?></div>
  <div class="col-lg-9">
    <div class="card-glass p-4 mb-3">
      <h4 class="fw-bold mb-1">Board of Management (BOM)</h4>
      <div class="text-muted">Maintain BOM list for the annual report section.</div>
      <hr class="border-0" style="height:1px;background:rgba(255,255,255,.10)">
      <form method="post" class="row g-2 align-items-end">
        <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
        <div class="col-md-4">
          <label class="form-label">Full Name</label>
          <input class="form-control" name="name" required placeholder="Member name">
        </div>
        <div class="col-md-3">
          <label class="form-label">Position</label>
          <input class="form-control" name="position" placeholder="Chair / Treasurer / Member">
        </div>
        <div class="col-md-2">
          <label class="form-label">Phone</label>
          <input class="form-control" name="phone" placeholder="+2547...">
        </div>
        <div class="col-md-1">
          <label class="form-label">From</label>
          <input class="form-control" type="date" name="term_from">
        </div>
        <div class="col-md-1">
          <label class="form-label">To</label>
          <input class="form-control" type="date" name="term_to">
        </div>
        <div class="col-md-1">
          <button class="btn btn-accent w-100">Add</button>
        </div>
      </form>
    </div>

    <div class="card-glass p-3">
      <div class="table-responsive">
        <table class="table table-darkish table-hover align-middle">
          <thead><tr><th>Name</th><th>Position</th><th>Phone</th><th>Term</th><th></th></tr></thead>
          <tbody>
            <?php foreach ($rows as $r): ?>
              <tr>
                <td><?= esc($r['name']) ?></td>
                <td><?= esc($r['position']) ?></td>
                <td class="text-muted"><?= esc($r['phone']) ?></td>
                <td class="text-muted small"><?= esc($r['term_from'] ?? '') ?> → <?= esc($r['term_to'] ?? '') ?></td>
                <td class="text-end">
                  <a class="btn btn-sm btn-outline-light" href="?del=<?= (int)$r['id'] ?>" onclick="return confirm('Delete?')">Delete</a>
                </td>
              </tr>
            <?php endforeach; ?>
            <?php if (!$rows): ?>
              <tr><td colspan="5" class="text-muted">No BOM members yet.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../partials/footer.php'; ?>
