<?php
require_once __DIR__ . '/../../../app/bootstrap.php';
$u = require_login(); $tid = tenant_id(); $pdo = db();
csrf_check();

// Add/update receivable (manual for MVP - can be linked to fee module later)
if ($_SERVER['REQUEST_METHOD']==='POST') {
  $debtor = trim((string)($_POST['debtor'] ?? ''));
  $date = (string)($_POST['date'] ?? date('Y-m-d'));
  $amount = (float)($_POST['amount'] ?? 0);
  if ($debtor !== '' && $amount > 0) {
    $pdo->prepare("INSERT INTO receivables (tenant_id,debtor,first_date,last_date,balance) VALUES (?,?,?,?,?)
                   ON DUPLICATE KEY UPDATE last_date=VALUES(last_date), balance=balance + VALUES(balance)")
        ->execute([$tid,$debtor,$date,$date,$amount]);
    flash("Receivable added.", "success");
    header("Location: receivables.php"); exit;
  }
  flash("Debtor and amount are required.", "danger");
}

$rows = $pdo->prepare("SELECT * FROM receivables WHERE tenant_id=? ORDER BY balance DESC, debtor");
$rows->execute([$tid]);
$rows = $rows->fetchAll();

function ageing_bucket(string $first_date): string {
  $d1 = new DateTime($first_date);
  $now = new DateTime();
  $days = (int)$now->diff($d1)->format('%a');
  if ($days < 365) return "< 1 year";
  if ($days < 730) return "1–2 years";
  if ($days < 1095) return "2–3 years";
  return "> 3 years";
}

$totals = ["< 1 year"=>0.0,"1–2 years"=>0.0,"2–3 years"=>0.0,"> 3 years"=>0.0];
foreach ($rows as $r) {
  $b = ageing_bucket($r['first_date']);
  $totals[$b] += (float)$r['balance'];
}

include __DIR__ . '/../../partials/header.php';
?>
<div class="row g-3">
  <div class="col-lg-3"><?php include __DIR__ . '/../../partials/sidebar.php'; ?></div>
  <div class="col-lg-9">
    <div class="card-glass p-4 mb-3">
      <h4 class="fw-bold mb-1">Receivables (Debtors) + Ageing</h4>
      <div class="text-muted">Used for Notes: Accounts receivable + ageing analysis.</div>
      <hr class="border-0" style="height:1px;background:rgba(255,255,255,.10)">
      <form method="post" class="row g-2 align-items-end">
        <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
        <div class="col-md-6">
          <label class="form-label">Debtor</label>
          <input class="form-control" name="debtor" placeholder="Fees arrears / Sponsor / Rent arrears / Staff advance" required>
        </div>
        <div class="col-md-2">
          <label class="form-label">First date</label>
          <input class="form-control" type="date" name="date" value="<?= esc(date('Y-m-d')) ?>" required>
        </div>
        <div class="col-md-2">
          <label class="form-label">Amount</label>
          <input class="form-control" type="number" step="0.01" name="amount" value="0" required>
        </div>
        <div class="col-md-2">
          <button class="btn btn-accent w-100">Add</button>
        </div>
      </form>
    </div>

    <div class="card-glass p-3 mb-3">
      <div class="fw-bold mb-2">Ageing summary</div>
      <div class="row g-2">
        <?php foreach ($totals as $k=>$v): ?>
          <div class="col-md-3">
            <div class="card-glass p-3 kpi">
              <div>
                <div class="label"><?= esc($k) ?></div>
                <div class="value">KSh <?= esc(money($v)) ?></div>
              </div>
              <div class="pill">Ageing</div>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    </div>

    <div class="card-glass p-3">
      <div class="table-responsive">
        <table class="table table-darkish table-hover align-middle">
          <thead><tr><th>Debtor</th><th>First date</th><th>Last date</th><th>Age bucket</th><th class="text-end">Balance</th></tr></thead>
          <tbody>
            <?php foreach ($rows as $r): $b = ageing_bucket($r['first_date']); ?>
              <tr>
                <td><?= esc($r['debtor']) ?></td>
                <td class="text-muted"><?= esc($r['first_date']) ?></td>
                <td class="text-muted"><?= esc($r['last_date']) ?></td>
                <td><span class="badge badge-soft"><?= esc($b) ?></span></td>
                <td class="text-end">KSh <?= esc(money($r['balance'])) ?></td>
              </tr>
            <?php endforeach; ?>
            <?php if (!$rows): ?>
              <tr><td colspan="5" class="text-muted">No receivables recorded yet.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../partials/footer.php'; ?>
