<?php
require_once __DIR__ . '/../../../app/bootstrap.php';
$u = require_login(); $tid = tenant_id(); $pdo = db();
csrf_check();

$fys = $pdo->prepare("SELECT id,label FROM fiscal_years WHERE tenant_id=? ORDER BY start_date DESC");
$fys->execute([$tid]); $fys = $fys->fetchAll();

$votes = $pdo->prepare("SELECT id, grp, name FROM vote_items WHERE tenant_id=? AND grp IN ('Tuition','Operations','Infrastructure','School Fund') ORDER BY grp, name");
$votes->execute([$tid]); $votes = $votes->fetchAll();

$banks = $pdo->prepare("SELECT id,name FROM bank_accounts WHERE tenant_id=? ORDER BY name");
$banks->execute([$tid]); $banks = $banks->fetchAll();

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $fy = (int)($_POST['fiscal_year_id'] ?? 0);
  $date = (string)($_POST['date'] ?? date('Y-m-d'));
  $supplier = trim((string)($_POST['supplier'] ?? ''));
  $reference = trim((string)($_POST['reference'] ?? ''));
  $mode = (string)($_POST['mode'] ?? 'Bank');
  $bank_id = ($_POST['bank_account_id'] ?? '') !== '' ? (int)$_POST['bank_account_id'] : null;

  $lines = $_POST['line'] ?? [];
  $total = 0.0;
  foreach ($lines as $ln) $total += (float)($ln['amount'] ?? 0);

  if ($fy<=0 || $supplier==='' || $total<=0) {
    flash("Please select FY, supplier, and add at least one expense line with amount.", "danger");
  } else {
    $bank_label = null;
    if ($bank_id) {
      $st = $pdo->prepare("SELECT name FROM bank_accounts WHERE tenant_id=? AND id=?");
      $st->execute([$tid,$bank_id]);
      $bank_label = $st->fetchColumn() ?: null;
    }

    $pdo->beginTransaction();
    $pdo->prepare("INSERT INTO payments (tenant_id,fiscal_year_id,date,supplier,reference,mode,bank_account_id,bank_label,total_amount,created_by) VALUES (?,?,?,?,?,?,?,?,?,?)")
        ->execute([$tid,$fy,$date,$supplier,$reference,$mode,$bank_id,$bank_label,$total,(int)$u['id']]);
    $pid = (int)$pdo->lastInsertId();

    $st = $pdo->prepare("INSERT INTO payment_lines (payment_id,vote_item_id,description,amount) VALUES (?,?,?,?)");
    foreach ($lines as $ln) {
      $vote = (int)($ln['vote_item_id'] ?? 0);
      $desc = trim((string)($ln['description'] ?? ''));
      $amt  = (float)($ln['amount'] ?? 0);
      if ($vote>0 && $amt>0) $st->execute([$pid,$vote,$desc,$amt]);
    }

    if ($mode==='Bank' && $bank_id) {
      $pdo->prepare("UPDATE bank_accounts SET balance = balance - ? WHERE tenant_id=? AND id=?")
          ->execute([$total,$tid,$bank_id]);
    } elseif ($mode==='Cash') {
      $pdo->prepare("INSERT INTO cash_drawer (tenant_id,as_at_date,amount) VALUES (?,?,?) ON DUPLICATE KEY UPDATE amount = amount - VALUES(amount)")
          ->execute([$tid, date('Y-m-d'), $total]);
    }

    // update payables register (simple: add balance)
    $pdo->prepare("INSERT INTO payables (tenant_id,supplier,first_date,last_date,balance) VALUES (?,?,?,?,?) 
                   ON DUPLICATE KEY UPDATE last_date=VALUES(last_date), balance=balance + VALUES(balance)")
        ->execute([$tid,$supplier,$date,$date,$total]);

    $pdo->prepare("INSERT INTO audit_log (tenant_id,user_id,action,entity,entity_id,details_json) VALUES (?,?,?,?,?,?)")
        ->execute([$tid,(int)$u['id'],'CREATE','payment',$pid,json_encode(['total'=>$total,'supplier'=>$supplier])]);

    $pdo->commit();
    flash("Payment saved.", "success");
    header("Location: payments_list.php"); exit;
  }
}

include __DIR__ . '/../../partials/header.php';
?>
<div class="row g-3">
  <div class="col-lg-3"><?php include __DIR__ . '/../../partials/sidebar.php'; ?></div>
  <div class="col-lg-9">
    <div class="card-glass p-4">
      <h4 class="fw-bold mb-1">New Payment</h4>
      <div class="text-muted mb-3">Capture expenditure lines (non-Revenue vote groups).</div>

      <form method="post">
        <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">

        <div class="row g-2">
          <div class="col-md-3">
            <label class="form-label">Fiscal Year</label>
            <select class="form-select" name="fiscal_year_id" required>
              <option value="">Select FY</option>
              <?php foreach ($fys as $fy): ?>
                <option value="<?= (int)$fy['id'] ?>"><?= esc($fy['label']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="col-md-3">
            <label class="form-label">Date</label>
            <input class="form-control" type="date" name="date" value="<?= esc(date('Y-m-d')) ?>">
          </div>
          <div class="col-md-3">
            <label class="form-label">Mode</label>
            <select class="form-select" name="mode" id="mode">
              <option>Bank</option>
              <option>Cash</option>
            </select>
          </div>
          <div class="col-md-3">
            <label class="form-label">Bank Account (if Bank)</label>
            <select class="form-select" name="bank_account_id">
              <option value="">—</option>
              <?php foreach ($banks as $b): ?>
                <option value="<?= (int)$b['id'] ?>"><?= esc($b['name']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="col-md-6">
            <label class="form-label">Supplier</label>
            <input class="form-control" name="supplier" required placeholder="Supplier / Contractor">
          </div>
          <div class="col-md-6">
            <label class="form-label">Reference / Invoice / Narrative</label>
            <input class="form-control" name="reference" placeholder="Invoice # / Description">
          </div>
        </div>

        <hr class="border-0" style="height:1px;background:rgba(255,255,255,.10)">

        <div class="d-flex justify-content-between align-items-center mb-2">
          <div class="fw-bold">Expense Lines</div>
          <button class="btn btn-outline-light btn-sm" type="button" onclick="addLine()">+ Add line</button>
        </div>

        <div class="table-responsive">
          <table class="table table-darkish align-middle" id="lines">
            <thead><tr><th style="width:34%">Vote Item</th><th>Description</th><th style="width:18%" class="text-end">Amount</th><th style="width:1%"></th></tr></thead>
            <tbody></tbody>
          </table>
        </div>

        <div class="d-flex gap-2">
          <button class="btn btn-accent">Save Payment</button>
          <a class="btn btn-outline-light" href="payments_list.php">Cancel</a>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
const voteOptions = `<?php foreach ($votes as $v){ echo "<option value='".(int)$v['id']."'>[".esc($v['grp'])."] ".esc($v['name'])."</option>"; } ?>`;
function addLine(){
  const tbody = document.querySelector('#lines tbody');
  const tr = document.createElement('tr');
  tr.innerHTML = `
    <td><select class="form-select" name="line[][vote_item_id]" required><option value="">Select</option>${voteOptions}</select></td>
    <td><input class="form-control" name="line[][description]" placeholder="Optional details"></td>
    <td class="text-end"><input class="form-control text-end" type="number" step="0.01" min="0" name="line[][amount]" required value="0"></td>
    <td><button class="btn btn-sm btn-outline-light" type="button" onclick="this.closest('tr').remove()">×</button></td>
  `;
  tbody.appendChild(tr);
}
addLine();
</script>

<?php include __DIR__ . '/../../partials/footer.php'; ?>
