<?php
require_once __DIR__ . '/../../../app/bootstrap.php';
$u = require_login(); $tid = tenant_id(); $pdo = db();

$st = $pdo->prepare("SELECT p.*, fy.label fy_label FROM payments p JOIN fiscal_years fy ON fy.id=p.fiscal_year_id
                     WHERE p.tenant_id=? ORDER BY p.date DESC, p.id DESC LIMIT 200");
$st->execute([$tid]);
$rows = $st->fetchAll();

include __DIR__ . '/../../partials/header.php';
?>
<div class="row g-3">
  <div class="col-lg-3"><?php include __DIR__ . '/../../partials/sidebar.php'; ?></div>
  <div class="col-lg-9">
    <div class="card-glass p-4 mb-3">
      <div class="d-flex justify-content-between align-items-start">
        <div>
          <h4 class="fw-bold mb-1">Payments</h4>
          <div class="text-muted">Capture vote-head classified expenditures (tuition/ops/infra/school fund).</div>
        </div>
        <a class="btn btn-accent" href="payments_new.php">+ New Payment</a>
      </div>
    </div>

    <div class="card-glass p-3">
      <div class="table-responsive">
        <table class="table table-darkish table-hover align-middle">
          <thead><tr><th>Date</th><th>FY</th><th>Supplier</th><th>Mode</th><th class="text-end">Amount</th></tr></thead>
          <tbody>
            <?php foreach ($rows as $r): ?>
              <tr>
                <td><?= esc($r['date']) ?></td>
                <td><span class="badge badge-soft"><?= esc($r['fy_label']) ?></span></td>
                <td><?= esc($r['supplier']) ?></td>
                <td><?= esc($r['mode']) ?><?= $r['bank_account_id'] ? ' · '.esc($r['bank_label']) : '' ?></td>
                <td class="text-end">KSh <?= esc(money($r['total_amount'])) ?></td>
              </tr>
            <?php endforeach; ?>
            <?php if (!$rows): ?>
              <tr><td colspan="5" class="text-muted">No payments yet.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../partials/footer.php'; ?>
