<?php
require_once __DIR__ . '/../../../app/bootstrap.php';
$u = require_login(); $tid = tenant_id(); $pdo = db();
csrf_check();

$fys = $pdo->prepare("SELECT id,label FROM fiscal_years WHERE tenant_id=? ORDER BY start_date DESC");
$fys->execute([$tid]); $fys = $fys->fetchAll();
$fy_id = (int)($_GET['fy'] ?? ($fys[0]['id'] ?? 0));

$vote = $pdo->prepare("SELECT id, grp, name FROM vote_items WHERE tenant_id=? ORDER BY FIELD(grp,'Revenue','Tuition','Operations','Infrastructure','School Fund'), name");
$vote->execute([$tid]); $vote = $vote->fetchAll();

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $fy_id = (int)($_POST['fy_id'] ?? 0);
  $vote_item_id = (int)($_POST['vote_item_id'] ?? 0);
  $original = (float)($_POST['original'] ?? 0);
  $adjust = (float)($_POST['adjustments'] ?? 0);

  $pdo->prepare("INSERT INTO budget_lines (tenant_id,fiscal_year_id,vote_item_id,original_budget,adjustments) VALUES (?,?,?,?,?)
                 ON DUPLICATE KEY UPDATE original_budget=VALUES(original_budget), adjustments=VALUES(adjustments)")
      ->execute([$tid,$fy_id,$vote_item_id,$original,$adjust]);

  flash("Budget line saved.", "success");
  header("Location: budget_lines.php?fy={$fy_id}"); exit;
}

// actuals by vote item
$actual_receipts = $pdo->prepare("
  SELECT rl.vote_item_id, SUM(rl.amount) amt
  FROM receipt_lines rl
  JOIN receipts r ON r.id=rl.receipt_id
  WHERE r.tenant_id=? AND r.fiscal_year_id=?
  GROUP BY rl.vote_item_id
");
$actual_receipts->execute([$tid,$fy_id]);
$ar = [];
foreach ($actual_receipts as $row) $ar[(int)$row['vote_item_id']] = (float)$row['amt'];

$actual_payments = $pdo->prepare("
  SELECT pl.vote_item_id, SUM(pl.amount) amt
  FROM payment_lines pl
  JOIN payments p ON p.id=pl.payment_id
  WHERE p.tenant_id=? AND p.fiscal_year_id=?
  GROUP BY pl.vote_item_id
");
$actual_payments->execute([$tid,$fy_id]);
$ap = [];
foreach ($actual_payments as $row) $ap[(int)$row['vote_item_id']] = (float)$row['amt'];

// budgets existing
$bst = $pdo->prepare("SELECT vote_item_id, original_budget, adjustments FROM budget_lines WHERE tenant_id=? AND fiscal_year_id=?");
$bst->execute([$tid,$fy_id]);
$bud = [];
foreach ($bst as $b) $bud[(int)$b['vote_item_id']] = $b;

include __DIR__ . '/../../partials/header.php';
?>
<div class="row g-3">
  <div class="col-lg-3"><?php include __DIR__ . '/../../partials/sidebar.php'; ?></div>
  <div class="col-lg-9">
    <div class="card-glass p-4 mb-3">
      <div class="d-flex justify-content-between align-items-start">
        <div>
          <h4 class="fw-bold mb-1">Budget vs Actual</h4>
          <div class="text-muted">Enter budgets for each vote item; actuals are pulled from receipts/payments.</div>
        </div>
        <form class="d-flex gap-2" method="get">
          <select class="form-select" name="fy" onchange="this.form.submit()">
            <?php foreach ($fys as $fy): ?>
              <option value="<?= (int)$fy['id'] ?>" <?= ($fy_id==(int)$fy['id'])?'selected':'' ?>><?= esc($fy['label']) ?></option>
            <?php endforeach; ?>
          </select>
        </form>
      </div>
    </div>

    <div class="card-glass p-3 mb-3">
      <div class="fw-bold mb-2">Update a budget line</div>
      <form method="post" class="row g-2 align-items-end">
        <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
        <input type="hidden" name="fy_id" value="<?= (int)$fy_id ?>">
        <div class="col-md-6">
          <label class="form-label">Vote item</label>
          <select class="form-select" name="vote_item_id" required>
            <option value="">Select vote item</option>
            <?php foreach ($vote as $v): ?>
              <option value="<?= (int)$v['id'] ?>">[<?= esc($v['grp']) ?>] <?= esc($v['name']) ?></option>
            <?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-2">
          <label class="form-label">Original</label>
          <input class="form-control" type="number" step="0.01" name="original" value="0">
        </div>
        <div class="col-md-2">
          <label class="form-label">Adjustments</label>
          <input class="form-control" type="number" step="0.01" name="adjustments" value="0">
        </div>
        <div class="col-md-2">
          <button class="btn btn-accent w-100">Save</button>
        </div>
      </form>
    </div>

    <div class="card-glass p-3">
      <div class="fw-bold mb-2">Budget table</div>
      <div class="table-responsive">
        <table class="table table-darkish table-hover align-middle">
          <thead>
            <tr>
              <th>Group</th><th>Item</th>
              <th class="text-end">Original</th>
              <th class="text-end">Adj</th>
              <th class="text-end">Final</th>
              <th class="text-end">Actual</th>
              <th class="text-end">% Util</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($vote as $v):
              $id = (int)$v['id'];
              $b = $bud[$id] ?? ['original_budget'=>0,'adjustments'=>0];
              $orig = (float)$b['original_budget'];
              $adj  = (float)$b['adjustments'];
              $final = $orig + $adj;
              $actual = 0.0;
              if ($v['grp']==='Revenue') $actual = $ar[$id] ?? 0.0; else $actual = $ap[$id] ?? 0.0;
              $pct = ($final>0) ? ($actual/$final*100.0) : 0.0;
            ?>
              <tr>
                <td><span class="badge badge-soft"><?= esc($v['grp']) ?></span></td>
                <td><?= esc($v['name']) ?></td>
                <td class="text-end"><?= esc(money($orig)) ?></td>
                <td class="text-end"><?= esc(money($adj)) ?></td>
                <td class="text-end fw-bold"><?= esc(money($final)) ?></td>
                <td class="text-end"><?= esc(money($actual)) ?></td>
                <td class="text-end">
                  <?php
                    $chip = 'badge-soft';
                    if ($pct>100) $chip = 'badge bg-danger';
                    elseif ($pct>=90) $chip = 'badge bg-success';
                    elseif ($pct>0) $chip = 'badge bg-warning text-dark';
                  ?>
                  <span class="<?= $chip ?>"><?= esc(number_format($pct,1)) ?>%</span>
                </td>
              </tr>
            <?php endforeach; ?>
            <?php if (!$vote): ?>
              <tr><td colspan="7" class="text-muted">No vote items. Setup → Vote Heads.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../partials/footer.php'; ?>
