<?php
require_once __DIR__ . '/../../../app/bootstrap.php';
$u = require_login(); $tid = tenant_id(); $pdo = db();

$st = $pdo->prepare("
  SELECT a.*, u.name user_name
  FROM audit_log a
  LEFT JOIN users u ON u.id=a.user_id
  WHERE a.tenant_id=?
  ORDER BY a.id DESC
  LIMIT 200
");
$st->execute([$tid]);
$rows = $st->fetchAll();

include __DIR__ . '/../../partials/header.php';
?>
<div class="row g-3">
  <div class="col-lg-3"><?php include __DIR__ . '/../../partials/sidebar.php'; ?></div>
  <div class="col-lg-9">
    <div class="card-glass p-4 mb-3">
      <h4 class="fw-bold mb-1">Audit Logs</h4>
      <div class="text-muted">Every significant action is logged (tenant-bound).</div>
    </div>

    <div class="card-glass p-3">
      <div class="table-responsive">
        <table class="table table-darkish table-hover align-middle">
          <thead><tr><th>Time</th><th>User</th><th>Action</th><th>Entity</th><th>Details</th></tr></thead>
          <tbody>
            <?php foreach ($rows as $r): ?>
              <tr>
                <td class="text-muted small"><?= esc($r['created_at']) ?></td>
                <td><?= esc($r['user_name'] ?? '—') ?></td>
                <td><span class="badge badge-soft"><?= esc($r['action']) ?></span></td>
                <td><?= esc($r['entity']) ?> #<?= (int)$r['entity_id'] ?></td>
                <td class="text-muted small"><?= esc($r['details_json']) ?></td>
              </tr>
            <?php endforeach; ?>
            <?php if (!$rows): ?>
              <tr><td colspan="5" class="text-muted">No logs yet.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../partials/footer.php'; ?>
