<?php
require_once __DIR__ . '/../../../app/bootstrap.php';
$u = require_login(); $tid = tenant_id(); $pdo = db();
csrf_check();

$classes = ['Land','Buildings','Furniture & Fittings','Motor Vehicles','ICT Equipment','Textbooks','Tools & Equipment','Software','Other'];

if ($_SERVER['REQUEST_METHOD']==='POST') {
  $asset_name = trim((string)($_POST['asset_name'] ?? ''));
  $asset_class = trim((string)($_POST['asset_class'] ?? 'Other'));
  $acq_date = (string)($_POST['acq_date'] ?? '');
  $cost = (float)($_POST['cost'] ?? 0);
  $condition = trim((string)($_POST['condition'] ?? 'Good'));
  $location = trim((string)($_POST['location'] ?? ''));
  if ($asset_name !== '' && $cost > 0) {
    $pdo->prepare("INSERT INTO assets (tenant_id,asset_name,asset_class,acq_date,cost,asset_condition,location) VALUES (?,?,?,?,?,?,?)")
        ->execute([$tid,$asset_name,$asset_class,$acq_date?:null,$cost,$condition,$location]);
    flash("Asset added.", "success");
    header("Location: assets.php"); exit;
  }
  flash("Asset name and cost are required.", "danger");
}

if (isset($_GET['del'])) {
  $id = (int)$_GET['del'];
  $pdo->prepare("DELETE FROM assets WHERE tenant_id=? AND id=?")->execute([$tid,$id]);
  flash("Deleted.", "warning");
  header("Location: assets.php"); exit;
}

$st = $pdo->prepare("SELECT * FROM assets WHERE tenant_id=? ORDER BY asset_class, asset_name");
$st->execute([$tid]);
$rows = $st->fetchAll();

include __DIR__ . '/../../partials/header.php';
?>
<div class="row g-3">
  <div class="col-lg-3"><?php include __DIR__ . '/../../partials/sidebar.php'; ?></div>
  <div class="col-lg-9">
    <div class="card-glass p-4 mb-3">
      <h4 class="fw-bold mb-1">Fixed Assets Register</h4>
      <div class="text-muted">Used to produce Annex II (Fixed assets summary).</div>
      <hr class="border-0" style="height:1px;background:rgba(255,255,255,.10)">
      <form method="post" class="row g-2 align-items-end">
        <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
        <div class="col-md-4">
          <label class="form-label">Asset name</label>
          <input class="form-control" name="asset_name" required placeholder="e.g., School bus, Computers, Dormitory block">
        </div>
        <div class="col-md-2">
          <label class="form-label">Class</label>
          <select class="form-select" name="asset_class">
            <?php foreach ($classes as $c): ?><option value="<?= esc($c) ?>"><?= esc($c) ?></option><?php endforeach; ?>
          </select>
        </div>
        <div class="col-md-2">
          <label class="form-label">Acquisition date</label>
          <input class="form-control" type="date" name="acq_date">
        </div>
        <div class="col-md-2">
          <label class="form-label">Cost</label>
          <input class="form-control" type="number" step="0.01" name="cost" value="0" required>
        </div>
        <div class="col-md-2">
          <label class="form-label">Condition</label>
          <input class="form-control" name="condition" value="Good">
        </div>
        <div class="col-12">
          <label class="form-label">Location (optional)</label>
          <input class="form-control" name="location" placeholder="Lab / Admin / Store / Dormitory">
        </div>
        <div class="col-12">
          <button class="btn btn-accent">Add Asset</button>
        </div>
      </form>
    </div>

    <div class="card-glass p-3">
      <div class="table-responsive">
        <table class="table table-darkish table-hover align-middle">
          <thead><tr><th>Class</th><th>Asset</th><th>Acq date</th><th class="text-end">Cost</th><th>Condition</th><th>Location</th><th></th></tr></thead>
          <tbody>
            <?php foreach ($rows as $r): ?>
              <tr>
                <td><span class="badge badge-soft"><?= esc($r['asset_class']) ?></span></td>
                <td><?= esc($r['asset_name']) ?></td>
                <td class="text-muted"><?= esc($r['acq_date'] ?? '') ?></td>
                <td class="text-end fw-bold"><?= esc(money($r['cost'])) ?></td>
                <td class="text-muted"><?= esc($r['asset_condition']) ?></td>
                <td class="text-muted"><?= esc($r['location']) ?></td>
                <td class="text-end">
                  <a class="btn btn-sm btn-outline-light" href="?del=<?= (int)$r['id'] ?>" onclick="return confirm('Delete?')">Delete</a>
                </td>
              </tr>
            <?php endforeach; ?>
            <?php if (!$rows): ?>
              <tr><td colspan="7" class="text-muted">No assets yet.</td></tr>
            <?php endif; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php include __DIR__ . '/../../partials/footer.php'; ?>
