<?php
require_once __DIR__ . '/../app/bootstrap.php';
csrf_check();

if (current_user()) { header('Location: index.php'); exit; }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $email = trim((string)($_POST['email'] ?? ''));
  $pass  = (string)($_POST['password'] ?? '');

  $stmt = db()->prepare("SELECT id, tenant_id, name, email, role, password_hash FROM users WHERE email=? AND is_active=1 LIMIT 1");
  $stmt->execute([$email]);
  $u = $stmt->fetch();

  if ($u && password_verify($pass, (string)$u['password_hash'])) {
    unset($u['password_hash']);
    $_SESSION['user'] = $u;

    // audit
    db()->prepare("INSERT INTO audit_log (tenant_id, user_id, action, entity, entity_id, details_json) VALUES (?,?,?,?,?,?)")
      ->execute([(int)$u['tenant_id'], (int)$u['id'], 'LOGIN', 'user', (int)$u['id'], json_encode(['email'=>$email])]);

    flash("Welcome back, {$u['name']}!", "success");
    header('Location: index.php'); exit;
  }

  flash("Invalid login.", "danger");
}

include __DIR__ . '/partials/header.php';
?>
<div class="row justify-content-center">
  <div class="col-md-6 col-lg-5">
    <div class="card-glass p-4">
      <h4 class="fw-bold mb-1">Sign in</h4>
      <div class="text-muted mb-3">Use your school account to access ShuleTrack.</div>
      <form method="post" class="d-grid gap-3">
        <input type="hidden" name="csrf" value="<?= esc(csrf_token()) ?>">
        <div>
          <label class="form-label">Email</label>
          <input class="form-control" type="email" name="email" required placeholder="bursar@school.go.ke">
        </div>
        <div>
          <label class="form-label">Password</label>
          <input class="form-control" type="password" name="password" required placeholder="••••••••">
        </div>
        <button class="btn btn-accent btn-lg">Login</button>
        <div class="text-muted small">
          Default demo: <span class="badge badge-soft">admin@school.local</span> / <span class="badge badge-soft">Admin@123</span>
        </div>
      </form>
    </div>
  </div>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
