<?php
require_once __DIR__ . '/../app/bootstrap.php';
$u = require_login();
$tid = tenant_id();
$pdo = db();

// KPIs
$fy_id = (int)($pdo->query("SELECT id FROM fiscal_years WHERE tenant_id={$tid} ORDER BY start_date DESC LIMIT 1")->fetch()['id'] ?? 0);

function scalar(PDO $pdo, string $sql, array $params=[]): float {
  $st = $pdo->prepare($sql); $st->execute($params);
  $r = $st->fetchColumn();
  return (float)($r ?? 0);
}

$bank_total = scalar($pdo, "SELECT COALESCE(SUM(balance),0) FROM bank_accounts WHERE tenant_id=?", [$tid]);
$cash_in_hand = scalar($pdo, "SELECT COALESCE(SUM(amount),0) FROM cash_drawer WHERE tenant_id=? AND as_at_date=CURDATE()", [$tid]);

$receipts_ytd = $fy_id ? scalar($pdo, "SELECT COALESCE(SUM(total_amount),0) FROM receipts WHERE tenant_id=? AND fiscal_year_id=?", [$tid,$fy_id]) : 0;
$payments_ytd = $fy_id ? scalar($pdo, "SELECT COALESCE(SUM(total_amount),0) FROM payments WHERE tenant_id=? AND fiscal_year_id=?", [$tid,$fy_id]) : 0;

$payables = scalar($pdo, "SELECT COALESCE(SUM(balance),0) FROM payables WHERE tenant_id=?", [$tid]);
$receivables = scalar($pdo, "SELECT COALESCE(SUM(balance),0) FROM receivables WHERE tenant_id=?", [$tid]);

include __DIR__ . '/partials/header.php';
?>
<div class="row g-3">
  <div class="col-lg-3">
    <?php include __DIR__ . '/partials/sidebar.php'; ?>
  </div>
  <div class="col-lg-9">
    <div class="row g-3">
      <div class="col-md-6">
        <div class="card-glass p-3 kpi">
          <div>
            <div class="label">Bank balances (total)</div>
            <div class="value">KSh <?= esc(money($bank_total)) ?></div>
          </div>
          <div class="pill">Accounts</div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="card-glass p-3 kpi">
          <div>
            <div class="label">Cash in hand (today)</div>
            <div class="value">KSh <?= esc(money($cash_in_hand)) ?></div>
          </div>
          <div class="pill">Cash</div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="card-glass p-3 kpi">
          <div>
            <div class="label">Receipts (latest FY)</div>
            <div class="value">KSh <?= esc(money($receipts_ytd)) ?></div>
          </div>
          <div class="pill">Income</div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="card-glass p-3 kpi">
          <div>
            <div class="label">Payments (latest FY)</div>
            <div class="value">KSh <?= esc(money($payments_ytd)) ?></div>
          </div>
          <div class="pill">Spending</div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="card-glass p-3 kpi">
          <div>
            <div class="label">Payables (outstanding)</div>
            <div class="value">KSh <?= esc(money($payables)) ?></div>
          </div>
          <div class="pill">Creditors</div>
        </div>
      </div>
      <div class="col-md-6">
        <div class="card-glass p-3 kpi">
          <div>
            <div class="label">Receivables (outstanding)</div>
            <div class="value">KSh <?= esc(money($receivables)) ?></div>
          </div>
          <div class="pill">Debtors</div>
        </div>
      </div>
    </div>

    <div class="card-glass p-3 mt-3">
      <div class="d-flex justify-content-between align-items-center">
        <div>
          <div class="fw-bold">Quick Actions</div>
          <div class="text-muted small">Add transactions fast and generate IPSAS outputs.</div>
        </div>
        <div class="d-flex gap-2">
          <a class="btn btn-accent" href="modules/finance/receipts_new.php">+ New Receipt</a>
          <a class="btn btn-outline-light" href="modules/finance/payments_new.php">+ New Payment</a>
          <a class="btn btn-outline-light" href="modules/reports/ipsas_pack.php">Generate IPSAS Pack</a>
        </div>
      </div>
    </div>

    <div class="card-glass p-3 mt-3">
      <div class="fw-bold mb-2">Onboarding Checklist</div>
      <ul class="text-muted small mb-0">
        <li>Setup School Profile</li>
        <li>Add Bank Accounts (Tuition/Operations/School Fund/Infrastructure/IGA)</li>
        <li>Create Fiscal Year (e.g., 2024/25) + Comparative year</li>
        <li>Define Vote Heads (mapped to IPSAS statements/notes)</li>
        <li>Enter Budget (Original + Adjustments)</li>
        <li>Start capturing Receipts & Payments</li>
        <li>Generate IPSAS pack for review & audit</li>
      </ul>
    </div>
  </div>
</div>
<?php include __DIR__ . '/partials/footer.php'; ?>
