# ShuleTrack — Single-School MVP (SaaS-Ready Foundation)

This is a **fully-advanced, stylish MVP** for a Kenyan public secondary school finance + IPSAS reporting system.
It is structured to later become **multi-school SaaS** by enabling tenant onboarding.

It supports:
- Setup (school profile, bank accounts, fiscal years, vote heads)
- Receipts & Payments
- Budget vs Actual
- Basic IPSAS report pages (HTML)
- Audit log
- Tenant-ready (`tenant_id` is included in tables; default tenant is `1`)

> The reports and data structures align with the IPSAS transitional template you provided.

---

## 1) Requirements
- PHP 8.1+ (tested structure for 8.2)
- MySQL/MariaDB
- Apache (cPanel/Truehost compatible)

## 2) Install
1. Upload project to your hosting (e.g., `/public_html/shuletrack`).
2. Create a MySQL database and user.
3. Copy `.env.example` to `.env` and set DB credentials + `APP_KEY`.
4. Import the schema:
   - `database/schema.sql`
5. Visit:
   - `public/login.php`

## 3) Default login
- Email: `admin@school.local`
- Password: `Admin@123`

**Change the password immediately** after first login (Settings screen can be added next).

## 4) Next upgrades (recommended)
- PDF export (Dompdf)
- Bank reconciliation import (CSV)
- Annex I / Annex II export to Excel
- Period locking per FY
- Multi-school SaaS onboarding UI

---
Generated on 2025-12-30.

## Advanced modules included
- Receivables register + ageing buckets
- Payables register + ageing buckets
- Annex I (Pending Payables) printable report
- Fixed Assets register + Annex II summary report
- Projects & Development register
- Governance: BOM members, committee meetings/minutes
- Cash positions (cash-in-hand by date) and Cash Flow (Direct Method) preview

PDF tip: use browser **Print → Save as PDF** for ministry-ready output.
